package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait AppInstanceDataType {
  def unwrap: software.amazon.awssdk.services.chime.model.AppInstanceDataType
}
object AppInstanceDataType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.AppInstanceDataType
  ): zio.aws.chime.model.AppInstanceDataType = value match {
    case software.amazon.awssdk.services.chime.model.AppInstanceDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.AppInstanceDataType.CHANNEL =>
      val r = Channel
      r
    case software.amazon.awssdk.services.chime.model.AppInstanceDataType.CHANNEL_MESSAGE =>
      val r = ChannelMessage
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.AppInstanceDataType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AppInstanceDataType =
      software.amazon.awssdk.services.chime.model.AppInstanceDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object Channel extends zio.aws.chime.model.AppInstanceDataType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AppInstanceDataType =
      software.amazon.awssdk.services.chime.model.AppInstanceDataType.CHANNEL
  }
  case object ChannelMessage extends zio.aws.chime.model.AppInstanceDataType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AppInstanceDataType =
      software.amazon.awssdk.services.chime.model.AppInstanceDataType.CHANNEL_MESSAGE
  }
}
