package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppInstanceRetentionSettings(
    channelRetentionSettings: Optional[
      zio.aws.chime.model.ChannelRetentionSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceRetentionSettings = {
    import AppInstanceRetentionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceRetentionSettings
      .builder()
      .optionallyWith(
        channelRetentionSettings.map(value => value.buildAwsValue())
      )(_.channelRetentionSettings)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly =
    zio.aws.chime.model.AppInstanceRetentionSettings.wrap(buildAwsValue())
}
object AppInstanceRetentionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceRetentionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceRetentionSettings =
      zio.aws.chime.model.AppInstanceRetentionSettings(
        channelRetentionSettings.map(value => value.asEditable)
      )
    def channelRetentionSettings
        : Optional[zio.aws.chime.model.ChannelRetentionSettings.ReadOnly]
    def getChannelRetentionSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelRetentionSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "channelRetentionSettings",
      channelRetentionSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceRetentionSettings
  ) extends zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly {
    override val channelRetentionSettings
        : Optional[zio.aws.chime.model.ChannelRetentionSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelRetentionSettings())
        .map(value => zio.aws.chime.model.ChannelRetentionSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceRetentionSettings
  ): zio.aws.chime.model.AppInstanceRetentionSettings.ReadOnly = new Wrapper(
    impl
  )
}
