package zio.aws.chime.model
import zio.aws.chime.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AppInstanceStreamingConfiguration(
    appInstanceDataType: zio.aws.chime.model.AppInstanceDataType,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration = {
    import AppInstanceStreamingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration
      .builder()
      .appInstanceDataType(appInstanceDataType.unwrap)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly =
    zio.aws.chime.model.AppInstanceStreamingConfiguration.wrap(buildAwsValue())
}
object AppInstanceStreamingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceStreamingConfiguration =
      zio.aws.chime.model
        .AppInstanceStreamingConfiguration(appInstanceDataType, resourceArn)
    def appInstanceDataType: zio.aws.chime.model.AppInstanceDataType
    def resourceArn: Arn
    def getAppInstanceDataType
        : ZIO[Any, Nothing, zio.aws.chime.model.AppInstanceDataType] =
      ZIO.succeed(appInstanceDataType)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration
  ) extends zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly {
    override val appInstanceDataType: zio.aws.chime.model.AppInstanceDataType =
      zio.aws.chime.model.AppInstanceDataType.wrap(impl.appInstanceDataType())
    override val resourceArn: Arn =
      zio.aws.chime.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceStreamingConfiguration
  ): zio.aws.chime.model.AppInstanceStreamingConfiguration.ReadOnly =
    new Wrapper(impl)
}
