package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, NonEmptyResourceName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppInstanceSummary(
    appInstanceArn: Optional[ChimeArn] = Optional.Absent,
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceSummary = {
    import AppInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceSummary
      .builder()
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceSummary.ReadOnly =
    zio.aws.chime.model.AppInstanceSummary.wrap(buildAwsValue())
}
object AppInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceSummary =
      zio.aws.chime.model.AppInstanceSummary(
        appInstanceArn.map(value => value),
        name.map(value => value),
        metadata.map(value => value)
      )
    def appInstanceArn: Optional[ChimeArn]
    def name: Optional[NonEmptyResourceName]
    def metadata: Optional[Metadata]
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceSummary
  ) extends zio.aws.chime.model.AppInstanceSummary.ReadOnly {
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.NonEmptyResourceName(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceSummary
  ): zio.aws.chime.model.AppInstanceSummary.ReadOnly = new Wrapper(impl)
}
