package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Metadata, Timestamp, UserName, ChimeArn}
import scala.jdk.CollectionConverters._
final case class AppInstanceUser(
    appInstanceUserArn: Optional[ChimeArn] = Optional.Absent,
    name: Optional[UserName] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceUser = {
    import AppInstanceUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceUser
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .optionallyWith(
        name.map(value => UserName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceUser.ReadOnly =
    zio.aws.chime.model.AppInstanceUser.wrap(buildAwsValue())
}
object AppInstanceUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceUser =
      zio.aws.chime.model.AppInstanceUser(
        appInstanceUserArn.map(value => value),
        name.map(value => value),
        createdTimestamp.map(value => value),
        metadata.map(value => value),
        lastUpdatedTimestamp.map(value => value)
      )
    def appInstanceUserArn: Optional[ChimeArn]
    def name: Optional[UserName]
    def createdTimestamp: Optional[Timestamp]
    def metadata: Optional[Metadata]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
    def getName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceUser
  ) extends zio.aws.chime.model.AppInstanceUser.ReadOnly {
    override val appInstanceUserArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val name: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.UserName(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceUser
  ): zio.aws.chime.model.AppInstanceUser.ReadOnly = new Wrapper(impl)
}
