package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, UserName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppInstanceUserSummary(
    appInstanceUserArn: Optional[ChimeArn] = Optional.Absent,
    name: Optional[UserName] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AppInstanceUserSummary = {
    import AppInstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AppInstanceUserSummary
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .optionallyWith(
        name.map(value => UserName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AppInstanceUserSummary.ReadOnly =
    zio.aws.chime.model.AppInstanceUserSummary.wrap(buildAwsValue())
}
object AppInstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AppInstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AppInstanceUserSummary =
      zio.aws.chime.model.AppInstanceUserSummary(
        appInstanceUserArn.map(value => value),
        name.map(value => value),
        metadata.map(value => value)
      )
    def appInstanceUserArn: Optional[ChimeArn]
    def name: Optional[UserName]
    def metadata: Optional[Metadata]
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
    def getName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("name", name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceUserSummary
  ) extends zio.aws.chime.model.AppInstanceUserSummary.ReadOnly {
    override val appInstanceUserArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val name: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.UserName(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AppInstanceUserSummary
  ): zio.aws.chime.model.AppInstanceUserSummary.ReadOnly = new Wrapper(impl)
}
