package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ArtifactsConfiguration(
    audio: zio.aws.chime.model.AudioArtifactsConfiguration,
    video: zio.aws.chime.model.VideoArtifactsConfiguration,
    content: zio.aws.chime.model.ContentArtifactsConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ArtifactsConfiguration = {
    import ArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ArtifactsConfiguration
      .builder()
      .audio(audio.buildAwsValue())
      .video(video.buildAwsValue())
      .content(content.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ArtifactsConfiguration.ReadOnly =
    zio.aws.chime.model.ArtifactsConfiguration.wrap(buildAwsValue())
}
object ArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ArtifactsConfiguration =
      zio.aws.chime.model.ArtifactsConfiguration(
        audio.asEditable,
        video.asEditable,
        content.asEditable
      )
    def audio: zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly
    def video: zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly
    def content: zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly
    def getAudio: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(audio)
    def getVideo: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(video)
    def getContent: ZIO[
      Any,
      Nothing,
      zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly
    ] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ArtifactsConfiguration
  ) extends zio.aws.chime.model.ArtifactsConfiguration.ReadOnly {
    override val audio
        : zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly =
      zio.aws.chime.model.AudioArtifactsConfiguration.wrap(impl.audio())
    override val video
        : zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly =
      zio.aws.chime.model.VideoArtifactsConfiguration.wrap(impl.video())
    override val content
        : zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly =
      zio.aws.chime.model.ContentArtifactsConfiguration.wrap(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ArtifactsConfiguration
  ): zio.aws.chime.model.ArtifactsConfiguration.ReadOnly = new Wrapper(impl)
}
