package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactsState {
  def unwrap: software.amazon.awssdk.services.chime.model.ArtifactsState
}
object ArtifactsState {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ArtifactsState
  ): zio.aws.chime.model.ArtifactsState = value match {
    case software.amazon.awssdk.services.chime.model.ArtifactsState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ArtifactsState.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.chime.model.ArtifactsState.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.ArtifactsState {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ArtifactsState =
      software.amazon.awssdk.services.chime.model.ArtifactsState.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.chime.model.ArtifactsState {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ArtifactsState =
      software.amazon.awssdk.services.chime.model.ArtifactsState.ENABLED
  }
  case object Disabled extends zio.aws.chime.model.ArtifactsState {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ArtifactsState =
      software.amazon.awssdk.services.chime.model.ArtifactsState.DISABLED
  }
}
