package zio.aws.chime.model
import zio.aws.chime.model.primitives.E164PhoneNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociatePhoneNumberWithUserRequest(
    accountId: String,
    userId: String,
    e164PhoneNumber: E164PhoneNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest = {
    import AssociatePhoneNumberWithUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .userId(userId: java.lang.String)
      .e164PhoneNumber(
        E164PhoneNumber.unwrap(e164PhoneNumber): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.AssociatePhoneNumberWithUserRequest.ReadOnly =
    zio.aws.chime.model.AssociatePhoneNumberWithUserRequest
      .wrap(buildAwsValue())
}
object AssociatePhoneNumberWithUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AssociatePhoneNumberWithUserRequest =
      zio.aws.chime.model
        .AssociatePhoneNumberWithUserRequest(accountId, userId, e164PhoneNumber)
    def accountId: String
    def userId: String
    def e164PhoneNumber: E164PhoneNumber
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
    def getE164PhoneNumber: ZIO[Any, Nothing, E164PhoneNumber] =
      ZIO.succeed(e164PhoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest
  ) extends zio.aws.chime.model.AssociatePhoneNumberWithUserRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val userId: String = impl.userId(): String
    override val e164PhoneNumber: E164PhoneNumber =
      zio.aws.chime.model.primitives.E164PhoneNumber(impl.e164PhoneNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AssociatePhoneNumberWithUserRequest
  ): zio.aws.chime.model.AssociatePhoneNumberWithUserRequest.ReadOnly =
    new Wrapper(impl)
}
