package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateSigninDelegateGroupsWithAccountRequest(
    accountId: NonEmptyString,
    signinDelegateGroups: Iterable[zio.aws.chime.model.SigninDelegateGroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest = {
    import AssociateSigninDelegateGroupsWithAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .signinDelegateGroups(signinDelegateGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest.ReadOnly =
    zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
      .wrap(buildAwsValue())
}
object AssociateSigninDelegateGroupsWithAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest =
      zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest(
        accountId,
        signinDelegateGroups.map { item =>
          item.asEditable
        }
      )
    def accountId: NonEmptyString
    def signinDelegateGroups
        : List[zio.aws.chime.model.SigninDelegateGroup.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getSigninDelegateGroups: ZIO[Any, Nothing, List[
      zio.aws.chime.model.SigninDelegateGroup.ReadOnly
    ]] = ZIO.succeed(signinDelegateGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
  ) extends zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val signinDelegateGroups
        : List[zio.aws.chime.model.SigninDelegateGroup.ReadOnly] = impl
      .signinDelegateGroups()
      .asScala
      .map { item =>
        zio.aws.chime.model.SigninDelegateGroup.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AssociateSigninDelegateGroupsWithAccountRequest
  ): zio.aws.chime.model.AssociateSigninDelegateGroupsWithAccountRequest.ReadOnly =
    new Wrapper(impl)
}
