package zio.aws.chime.model
import zio.aws.chime.model.primitives.{
  JoinTokenString,
  GuidString,
  ExternalUserIdType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Attendee(
    externalUserId: Optional[ExternalUserIdType] = Optional.Absent,
    attendeeId: Optional[GuidString] = Optional.Absent,
    joinToken: Optional[JoinTokenString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Attendee = {
    import Attendee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Attendee
      .builder()
      .optionallyWith(
        externalUserId.map(value =>
          ExternalUserIdType.unwrap(value): java.lang.String
        )
      )(_.externalUserId)
      .optionallyWith(
        attendeeId.map(value => GuidString.unwrap(value): java.lang.String)
      )(_.attendeeId)
      .optionallyWith(
        joinToken.map(value => JoinTokenString.unwrap(value): java.lang.String)
      )(_.joinToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Attendee.ReadOnly =
    zio.aws.chime.model.Attendee.wrap(buildAwsValue())
}
object Attendee {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Attendee] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Attendee = zio.aws.chime.model.Attendee(
      externalUserId.map(value => value),
      attendeeId.map(value => value),
      joinToken.map(value => value)
    )
    def externalUserId: Optional[ExternalUserIdType]
    def attendeeId: Optional[GuidString]
    def joinToken: Optional[JoinTokenString]
    def getExternalUserId: ZIO[Any, AwsError, ExternalUserIdType] =
      AwsError.unwrapOptionField("externalUserId", externalUserId)
    def getAttendeeId: ZIO[Any, AwsError, GuidString] =
      AwsError.unwrapOptionField("attendeeId", attendeeId)
    def getJoinToken: ZIO[Any, AwsError, JoinTokenString] =
      AwsError.unwrapOptionField("joinToken", joinToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Attendee
  ) extends zio.aws.chime.model.Attendee.ReadOnly {
    override val externalUserId: Optional[ExternalUserIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUserId())
        .map(value => zio.aws.chime.model.primitives.ExternalUserIdType(value))
    override val attendeeId: Optional[GuidString] = zio.aws.core.internal
      .optionalFromNullable(impl.attendeeId())
      .map(value => zio.aws.chime.model.primitives.GuidString(value))
    override val joinToken: Optional[JoinTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.joinToken())
      .map(value => zio.aws.chime.model.primitives.JoinTokenString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Attendee
  ): zio.aws.chime.model.Attendee.ReadOnly = new Wrapper(impl)
}
