package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AudioArtifactsConfiguration(
    muxType: zio.aws.chime.model.AudioMuxType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.AudioArtifactsConfiguration = {
    import AudioArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.AudioArtifactsConfiguration
      .builder()
      .muxType(muxType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly =
    zio.aws.chime.model.AudioArtifactsConfiguration.wrap(buildAwsValue())
}
object AudioArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.AudioArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.AudioArtifactsConfiguration =
      zio.aws.chime.model.AudioArtifactsConfiguration(muxType)
    def muxType: zio.aws.chime.model.AudioMuxType
    def getMuxType: ZIO[Any, Nothing, zio.aws.chime.model.AudioMuxType] =
      ZIO.succeed(muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.AudioArtifactsConfiguration
  ) extends zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly {
    override val muxType: zio.aws.chime.model.AudioMuxType =
      zio.aws.chime.model.AudioMuxType.wrap(impl.muxType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.AudioArtifactsConfiguration
  ): zio.aws.chime.model.AudioArtifactsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
