package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait AudioMuxType {
  def unwrap: software.amazon.awssdk.services.chime.model.AudioMuxType
}
object AudioMuxType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.AudioMuxType
  ): zio.aws.chime.model.AudioMuxType = value match {
    case software.amazon.awssdk.services.chime.model.AudioMuxType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.AudioMuxType.AUDIO_ONLY =>
      val r = AudioOnly
      r
    case software.amazon.awssdk.services.chime.model.AudioMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO =>
      val r = AudioWithActiveSpeakerVideo
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AudioMuxType =
      software.amazon.awssdk.services.chime.model.AudioMuxType.UNKNOWN_TO_SDK_VERSION
  }
  case object AudioOnly extends zio.aws.chime.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AudioMuxType =
      software.amazon.awssdk.services.chime.model.AudioMuxType.AUDIO_ONLY
  }
  case object AudioWithActiveSpeakerVideo
      extends zio.aws.chime.model.AudioMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.AudioMuxType =
      software.amazon.awssdk.services.chime.model.AudioMuxType.AUDIO_WITH_ACTIVE_SPEAKER_VIDEO
  }
}
