package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchCreateAttendeeRequest(
    meetingId: GuidString,
    attendees: Iterable[zio.aws.chime.model.CreateAttendeeRequestItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest = {
    import BatchCreateAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendees(attendees.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchCreateAttendeeRequest.ReadOnly =
    zio.aws.chime.model.BatchCreateAttendeeRequest.wrap(buildAwsValue())
}
object BatchCreateAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchCreateAttendeeRequest =
      zio.aws.chime.model.BatchCreateAttendeeRequest(
        meetingId,
        attendees.map { item =>
          item.asEditable
        }
      )
    def meetingId: GuidString
    def attendees: List[zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendees: ZIO[Any, Nothing, List[
      zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly
    ]] = ZIO.succeed(attendees)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest
  ) extends zio.aws.chime.model.BatchCreateAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val attendees
        : List[zio.aws.chime.model.CreateAttendeeRequestItem.ReadOnly] = impl
      .attendees()
      .asScala
      .map { item =>
        zio.aws.chime.model.CreateAttendeeRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateAttendeeRequest
  ): zio.aws.chime.model.BatchCreateAttendeeRequest.ReadOnly = new Wrapper(impl)
}
