package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipRequest(
    channelArn: ChimeArn,
    `type`: Optional[zio.aws.chime.model.ChannelMembershipType] =
      Optional.Absent,
    memberArns: Iterable[ChimeArn],
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest = {
    import BatchCreateChannelMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .memberArns(memberArns.map { item =>
        ChimeArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.BatchCreateChannelMembershipRequest.ReadOnly =
    zio.aws.chime.model.BatchCreateChannelMembershipRequest
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchCreateChannelMembershipRequest =
      zio.aws.chime.model.BatchCreateChannelMembershipRequest(
        channelArn,
        `type`.map(value => value),
        memberArns,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def `type`: Optional[zio.aws.chime.model.ChannelMembershipType]
    def memberArns: List[ChimeArn]
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getType: ZIO[Any, AwsError, zio.aws.chime.model.ChannelMembershipType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMemberArns: ZIO[Any, Nothing, List[ChimeArn]] =
      ZIO.succeed(memberArns)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest
  ) extends zio.aws.chime.model.BatchCreateChannelMembershipRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val `type`: Optional[zio.aws.chime.model.ChannelMembershipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.chime.model.ChannelMembershipType.wrap(value))
    override val memberArns: List[ChimeArn] = impl
      .memberArns()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.ChimeArn(item)
      }
      .toList
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipRequest
  ): zio.aws.chime.model.BatchCreateChannelMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
