package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateChannelMembershipResponse(
    batchChannelMemberships: Optional[
      zio.aws.chime.model.BatchChannelMemberships
    ] = Optional.Absent,
    errors: Optional[
      Iterable[zio.aws.chime.model.BatchCreateChannelMembershipError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipResponse = {
    import BatchCreateChannelMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipResponse
      .builder()
      .optionallyWith(
        batchChannelMemberships.map(value => value.buildAwsValue())
      )(_.batchChannelMemberships)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly =
    zio.aws.chime.model.BatchCreateChannelMembershipResponse
      .wrap(buildAwsValue())
}
object BatchCreateChannelMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchCreateChannelMembershipResponse =
      zio.aws.chime.model.BatchCreateChannelMembershipResponse(
        batchChannelMemberships.map(value => value.asEditable),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def batchChannelMemberships
        : Optional[zio.aws.chime.model.BatchChannelMemberships.ReadOnly]
    def errors: Optional[
      List[zio.aws.chime.model.BatchCreateChannelMembershipError.ReadOnly]
    ]
    def getBatchChannelMemberships: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.BatchChannelMemberships.ReadOnly
    ] = AwsError.unwrapOptionField(
      "batchChannelMemberships",
      batchChannelMemberships
    )
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.chime.model.BatchCreateChannelMembershipError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipResponse
  ) extends zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly {
    override val batchChannelMemberships
        : Optional[zio.aws.chime.model.BatchChannelMemberships.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchChannelMemberships())
        .map(value => zio.aws.chime.model.BatchChannelMemberships.wrap(value))
    override val errors: Optional[
      List[zio.aws.chime.model.BatchCreateChannelMembershipError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.BatchCreateChannelMembershipError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipResponse
  ): zio.aws.chime.model.BatchCreateChannelMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
