package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchCreateRoomMembershipRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString,
    membershipItemList: Iterable[zio.aws.chime.model.MembershipItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest = {
    import BatchCreateRoomMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .membershipItemList(membershipItemList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.BatchCreateRoomMembershipRequest.ReadOnly =
    zio.aws.chime.model.BatchCreateRoomMembershipRequest.wrap(buildAwsValue())
}
object BatchCreateRoomMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchCreateRoomMembershipRequest =
      zio.aws.chime.model.BatchCreateRoomMembershipRequest(
        accountId,
        roomId,
        membershipItemList.map { item =>
          item.asEditable
        }
      )
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def membershipItemList: List[zio.aws.chime.model.MembershipItem.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
    def getMembershipItemList
        : ZIO[Any, Nothing, List[zio.aws.chime.model.MembershipItem.ReadOnly]] =
      ZIO.succeed(membershipItemList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest
  ) extends zio.aws.chime.model.BatchCreateRoomMembershipRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
    override val membershipItemList
        : List[zio.aws.chime.model.MembershipItem.ReadOnly] = impl
      .membershipItemList()
      .asScala
      .map { item =>
        zio.aws.chime.model.MembershipItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipRequest
  ): zio.aws.chime.model.BatchCreateRoomMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
