package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateRoomMembershipResponse(
    errors: Optional[Iterable[zio.aws.chime.model.MemberError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse = {
    import BatchCreateRoomMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.BatchCreateRoomMembershipResponse.ReadOnly =
    zio.aws.chime.model.BatchCreateRoomMembershipResponse.wrap(buildAwsValue())
}
object BatchCreateRoomMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchCreateRoomMembershipResponse =
      zio.aws.chime.model.BatchCreateRoomMembershipResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[List[zio.aws.chime.model.MemberError.ReadOnly]]
    def getErrors
        : ZIO[Any, AwsError, List[zio.aws.chime.model.MemberError.ReadOnly]] =
      AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse
  ) extends zio.aws.chime.model.BatchCreateRoomMembershipResponse.ReadOnly {
    override val errors
        : Optional[List[zio.aws.chime.model.MemberError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.MemberError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchCreateRoomMembershipResponse
  ): zio.aws.chime.model.BatchCreateRoomMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
