package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeletePhoneNumberRequest(
    phoneNumberIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest = {
    import BatchDeletePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest
      .builder()
      .phoneNumberIds(phoneNumberIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchDeletePhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.BatchDeletePhoneNumberRequest.wrap(buildAwsValue())
}
object BatchDeletePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchDeletePhoneNumberRequest =
      zio.aws.chime.model.BatchDeletePhoneNumberRequest(phoneNumberIds)
    def phoneNumberIds: List[String]
    def getPhoneNumberIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(phoneNumberIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest
  ) extends zio.aws.chime.model.BatchDeletePhoneNumberRequest.ReadOnly {
    override val phoneNumberIds: List[String] = impl
      .phoneNumberIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchDeletePhoneNumberRequest
  ): zio.aws.chime.model.BatchDeletePhoneNumberRequest.ReadOnly = new Wrapper(
    impl
  )
}
