package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchSuspendUserRequest(
    accountId: NonEmptyString,
    userIdList: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest = {
    import BatchSuspendUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userIdList(userIdList.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchSuspendUserRequest.ReadOnly =
    zio.aws.chime.model.BatchSuspendUserRequest.wrap(buildAwsValue())
}
object BatchSuspendUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchSuspendUserRequest =
      zio.aws.chime.model.BatchSuspendUserRequest(accountId, userIdList)
    def accountId: NonEmptyString
    def userIdList: List[NonEmptyString]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserIdList: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(userIdList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest
  ) extends zio.aws.chime.model.BatchSuspendUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userIdList: List[NonEmptyString] = impl
      .userIdList()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchSuspendUserRequest
  ): zio.aws.chime.model.BatchSuspendUserRequest.ReadOnly = new Wrapper(impl)
}
