package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchSuspendUserResponse(
    userErrors: Optional[Iterable[zio.aws.chime.model.UserError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse = {
    import BatchSuspendUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse
      .builder()
      .optionallyWith(
        userErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userErrors)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly =
    zio.aws.chime.model.BatchSuspendUserResponse.wrap(buildAwsValue())
}
object BatchSuspendUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchSuspendUserResponse =
      zio.aws.chime.model.BatchSuspendUserResponse(
        userErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userErrors: Optional[List[zio.aws.chime.model.UserError.ReadOnly]]
    def getUserErrors
        : ZIO[Any, AwsError, List[zio.aws.chime.model.UserError.ReadOnly]] =
      AwsError.unwrapOptionField("userErrors", userErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse
  ) extends zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly {
    override val userErrors
        : Optional[List[zio.aws.chime.model.UserError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.UserError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchSuspendUserResponse
  ): zio.aws.chime.model.BatchSuspendUserResponse.ReadOnly = new Wrapper(impl)
}
