package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUnsuspendUserRequest(
    accountId: NonEmptyString,
    userIdList: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest = {
    import BatchUnsuspendUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .userIdList(userIdList.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchUnsuspendUserRequest.ReadOnly =
    zio.aws.chime.model.BatchUnsuspendUserRequest.wrap(buildAwsValue())
}
object BatchUnsuspendUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchUnsuspendUserRequest =
      zio.aws.chime.model.BatchUnsuspendUserRequest(accountId, userIdList)
    def accountId: NonEmptyString
    def userIdList: List[NonEmptyString]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUserIdList: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(userIdList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest
  ) extends zio.aws.chime.model.BatchUnsuspendUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val userIdList: List[NonEmptyString] = impl
      .userIdList()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchUnsuspendUserRequest
  ): zio.aws.chime.model.BatchUnsuspendUserRequest.ReadOnly = new Wrapper(impl)
}
