package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchUnsuspendUserResponse(
    userErrors: Optional[Iterable[zio.aws.chime.model.UserError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse = {
    import BatchUnsuspendUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse
      .builder()
      .optionallyWith(
        userErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userErrors)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly =
    zio.aws.chime.model.BatchUnsuspendUserResponse.wrap(buildAwsValue())
}
object BatchUnsuspendUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchUnsuspendUserResponse =
      zio.aws.chime.model.BatchUnsuspendUserResponse(
        userErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userErrors: Optional[List[zio.aws.chime.model.UserError.ReadOnly]]
    def getUserErrors
        : ZIO[Any, AwsError, List[zio.aws.chime.model.UserError.ReadOnly]] =
      AwsError.unwrapOptionField("userErrors", userErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse
  ) extends zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly {
    override val userErrors
        : Optional[List[zio.aws.chime.model.UserError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.UserError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchUnsuspendUserResponse
  ): zio.aws.chime.model.BatchUnsuspendUserResponse.ReadOnly = new Wrapper(impl)
}
