package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdatePhoneNumberRequest(
    updatePhoneNumberRequestItems: Iterable[
      zio.aws.chime.model.UpdatePhoneNumberRequestItem
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest = {
    import BatchUpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest
      .builder()
      .updatePhoneNumberRequestItems(updatePhoneNumberRequestItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchUpdatePhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.BatchUpdatePhoneNumberRequest.wrap(buildAwsValue())
}
object BatchUpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchUpdatePhoneNumberRequest =
      zio.aws.chime.model.BatchUpdatePhoneNumberRequest(
        updatePhoneNumberRequestItems.map { item =>
          item.asEditable
        }
      )
    def updatePhoneNumberRequestItems
        : List[zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly]
    def getUpdatePhoneNumberRequestItems: ZIO[Any, Nothing, List[
      zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly
    ]] = ZIO.succeed(updatePhoneNumberRequestItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest
  ) extends zio.aws.chime.model.BatchUpdatePhoneNumberRequest.ReadOnly {
    override val updatePhoneNumberRequestItems
        : List[zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly] = impl
      .updatePhoneNumberRequestItems()
      .asScala
      .map { item =>
        zio.aws.chime.model.UpdatePhoneNumberRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdatePhoneNumberRequest
  ): zio.aws.chime.model.BatchUpdatePhoneNumberRequest.ReadOnly = new Wrapper(
    impl
  )
}
