package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateUserRequest(
    accountId: NonEmptyString,
    updateUserRequestItems: Iterable[zio.aws.chime.model.UpdateUserRequestItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest = {
    import BatchUpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .updateUserRequestItems(updateUserRequestItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchUpdateUserRequest.ReadOnly =
    zio.aws.chime.model.BatchUpdateUserRequest.wrap(buildAwsValue())
}
object BatchUpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchUpdateUserRequest =
      zio.aws.chime.model.BatchUpdateUserRequest(
        accountId,
        updateUserRequestItems.map { item =>
          item.asEditable
        }
      )
    def accountId: NonEmptyString
    def updateUserRequestItems
        : List[zio.aws.chime.model.UpdateUserRequestItem.ReadOnly]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getUpdateUserRequestItems: ZIO[Any, Nothing, List[
      zio.aws.chime.model.UpdateUserRequestItem.ReadOnly
    ]] = ZIO.succeed(updateUserRequestItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest
  ) extends zio.aws.chime.model.BatchUpdateUserRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val updateUserRequestItems
        : List[zio.aws.chime.model.UpdateUserRequestItem.ReadOnly] = impl
      .updateUserRequestItems()
      .asScala
      .map { item =>
        zio.aws.chime.model.UpdateUserRequestItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdateUserRequest
  ): zio.aws.chime.model.BatchUpdateUserRequest.ReadOnly = new Wrapper(impl)
}
