package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchUpdateUserResponse(
    userErrors: Optional[Iterable[zio.aws.chime.model.UserError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse = {
    import BatchUpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse
      .builder()
      .optionallyWith(
        userErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userErrors)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly =
    zio.aws.chime.model.BatchUpdateUserResponse.wrap(buildAwsValue())
}
object BatchUpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BatchUpdateUserResponse =
      zio.aws.chime.model.BatchUpdateUserResponse(
        userErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def userErrors: Optional[List[zio.aws.chime.model.UserError.ReadOnly]]
    def getUserErrors
        : ZIO[Any, AwsError, List[zio.aws.chime.model.UserError.ReadOnly]] =
      AwsError.unwrapOptionField("userErrors", userErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse
  ) extends zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly {
    override val userErrors
        : Optional[List[zio.aws.chime.model.UserError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.UserError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BatchUpdateUserResponse
  ): zio.aws.chime.model.BatchUpdateUserResponse.ReadOnly = new Wrapper(impl)
}
