package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Iso8601Timestamp,
  NullableBoolean,
  SensitiveString
}
import scala.jdk.CollectionConverters._
final case class Bot(
    botId: Optional[String] = Optional.Absent,
    userId: Optional[String] = Optional.Absent,
    displayName: Optional[SensitiveString] = Optional.Absent,
    botType: Optional[zio.aws.chime.model.BotType] = Optional.Absent,
    disabled: Optional[NullableBoolean] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    botEmail: Optional[SensitiveString] = Optional.Absent,
    securityToken: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.Bot = {
    import Bot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.Bot
      .builder()
      .optionallyWith(botId.map(value => value: java.lang.String))(_.botId)
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(
        displayName.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(botType.map(value => value.unwrap))(_.botType)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        botEmail.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.botEmail)
      .optionallyWith(
        securityToken.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.securityToken)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.Bot.ReadOnly =
    zio.aws.chime.model.Bot.wrap(buildAwsValue())
}
object Bot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.Bot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.Bot = zio.aws.chime.model.Bot(
      botId.map(value => value),
      userId.map(value => value),
      displayName.map(value => value),
      botType.map(value => value),
      disabled.map(value => value),
      createdTimestamp.map(value => value),
      updatedTimestamp.map(value => value),
      botEmail.map(value => value),
      securityToken.map(value => value)
    )
    def botId: Optional[String]
    def userId: Optional[String]
    def displayName: Optional[SensitiveString]
    def botType: Optional[zio.aws.chime.model.BotType]
    def disabled: Optional[NullableBoolean]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def botEmail: Optional[SensitiveString]
    def securityToken: Optional[SensitiveString]
    def getBotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("botId", botId)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getDisplayName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getBotType: ZIO[Any, AwsError, zio.aws.chime.model.BotType] =
      AwsError.unwrapOptionField("botType", botType)
    def getDisabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getBotEmail: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("botEmail", botEmail)
    def getSecurityToken: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("securityToken", securityToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.Bot
  ) extends zio.aws.chime.model.Bot.ReadOnly {
    override val botId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.botId())
      .map(value => value: String)
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val displayName: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val botType: Optional[zio.aws.chime.model.BotType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.botType())
        .map(value => zio.aws.chime.model.BotType.wrap(value))
    override val disabled: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: NullableBoolean)
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val botEmail: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.botEmail())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val securityToken: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityToken())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.Bot
  ): zio.aws.chime.model.Bot.ReadOnly = new Wrapper(impl)
}
