package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait BotType {
  def unwrap: software.amazon.awssdk.services.chime.model.BotType
}
object BotType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.BotType
  ): zio.aws.chime.model.BotType = value match {
    case software.amazon.awssdk.services.chime.model.BotType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.BotType.CHAT_BOT =>
      val r = ChatBot
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.BotType {
    override def unwrap: software.amazon.awssdk.services.chime.model.BotType =
      software.amazon.awssdk.services.chime.model.BotType.UNKNOWN_TO_SDK_VERSION
  }
  case object ChatBot extends zio.aws.chime.model.BotType {
    override def unwrap: software.amazon.awssdk.services.chime.model.BotType =
      software.amazon.awssdk.services.chime.model.BotType.CHAT_BOT
  }
}
