package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BusinessCallingSettings(
    cdrBucket: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.BusinessCallingSettings = {
    import BusinessCallingSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.BusinessCallingSettings
      .builder()
      .optionallyWith(cdrBucket.map(value => value: java.lang.String))(
        _.cdrBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.BusinessCallingSettings.ReadOnly =
    zio.aws.chime.model.BusinessCallingSettings.wrap(buildAwsValue())
}
object BusinessCallingSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.BusinessCallingSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.BusinessCallingSettings =
      zio.aws.chime.model.BusinessCallingSettings(cdrBucket.map(value => value))
    def cdrBucket: Optional[String]
    def getCdrBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdrBucket", cdrBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.BusinessCallingSettings
  ) extends zio.aws.chime.model.BusinessCallingSettings.ReadOnly {
    override val cdrBucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdrBucket())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.BusinessCallingSettings
  ): zio.aws.chime.model.BusinessCallingSettings.ReadOnly = new Wrapper(impl)
}
