package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait Capability {
  def unwrap: software.amazon.awssdk.services.chime.model.Capability
}
object Capability {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.Capability
  ): zio.aws.chime.model.Capability = value match {
    case software.amazon.awssdk.services.chime.model.Capability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.Capability.VOICE =>
      val r = Voice
      r
    case software.amazon.awssdk.services.chime.model.Capability.SMS =>
      val r = SMS
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.Capability =
      software.amazon.awssdk.services.chime.model.Capability.UNKNOWN_TO_SDK_VERSION
  }
  case object Voice extends zio.aws.chime.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.Capability =
      software.amazon.awssdk.services.chime.model.Capability.VOICE
  }
  case object SMS extends zio.aws.chime.model.Capability {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.Capability =
      software.amazon.awssdk.services.chime.model.Capability.SMS
  }
}
