package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Timestamp, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelBan(
    member: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelBan = {
    import ChannelBan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelBan
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelBan.ReadOnly =
    zio.aws.chime.model.ChannelBan.wrap(buildAwsValue())
}
object ChannelBan {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.ChannelBan] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelBan =
      zio.aws.chime.model.ChannelBan(
        member.map(value => value.asEditable),
        channelArn.map(value => value),
        createdTimestamp.map(value => value),
        createdBy.map(value => value.asEditable)
      )
    def member: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def channelArn: Optional[ChimeArn]
    def createdTimestamp: Optional[Timestamp]
    def createdBy: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getMember: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelBan
  ) extends zio.aws.chime.model.ChannelBan.ReadOnly {
    override val member: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val createdBy: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelBan
  ): zio.aws.chime.model.ChannelBan.ReadOnly = new Wrapper(impl)
}
