package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelMembershipForAppInstanceUserSummary(
    channelSummary: Optional[zio.aws.chime.model.ChannelSummary] =
      Optional.Absent,
    appInstanceUserMembershipSummary: Optional[
      zio.aws.chime.model.AppInstanceUserMembershipSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelMembershipForAppInstanceUserSummary = {
    import ChannelMembershipForAppInstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelMembershipForAppInstanceUserSummary
      .builder()
      .optionallyWith(channelSummary.map(value => value.buildAwsValue()))(
        _.channelSummary
      )
      .optionallyWith(
        appInstanceUserMembershipSummary.map(value => value.buildAwsValue())
      )(_.appInstanceUserMembershipSummary)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly =
    zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary
      .wrap(buildAwsValue())
}
object ChannelMembershipForAppInstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelMembershipForAppInstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary =
      zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary(
        channelSummary.map(value => value.asEditable),
        appInstanceUserMembershipSummary.map(value => value.asEditable)
      )
    def channelSummary: Optional[zio.aws.chime.model.ChannelSummary.ReadOnly]
    def appInstanceUserMembershipSummary: Optional[
      zio.aws.chime.model.AppInstanceUserMembershipSummary.ReadOnly
    ]
    def getChannelSummary
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelSummary.ReadOnly] =
      AwsError.unwrapOptionField("channelSummary", channelSummary)
    def getAppInstanceUserMembershipSummary: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.AppInstanceUserMembershipSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appInstanceUserMembershipSummary",
      appInstanceUserMembershipSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelMembershipForAppInstanceUserSummary
  ) extends zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly {
    override val channelSummary
        : Optional[zio.aws.chime.model.ChannelSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelSummary())
        .map(value => zio.aws.chime.model.ChannelSummary.wrap(value))
    override val appInstanceUserMembershipSummary: Optional[
      zio.aws.chime.model.AppInstanceUserMembershipSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserMembershipSummary())
      .map(value =>
        zio.aws.chime.model.AppInstanceUserMembershipSummary.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelMembershipForAppInstanceUserSummary
  ): zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary.ReadOnly =
    new Wrapper(impl)
}
