package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelMembershipSummary(
    member: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelMembershipSummary = {
    import ChannelMembershipSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelMembershipSummary
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelMembershipSummary.ReadOnly =
    zio.aws.chime.model.ChannelMembershipSummary.wrap(buildAwsValue())
}
object ChannelMembershipSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelMembershipSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelMembershipSummary =
      zio.aws.chime.model
        .ChannelMembershipSummary(member.map(value => value.asEditable))
    def member: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getMember: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelMembershipSummary
  ) extends zio.aws.chime.model.ChannelMembershipSummary.ReadOnly {
    override val member: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.member())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelMembershipSummary
  ): zio.aws.chime.model.ChannelMembershipSummary.ReadOnly = new Wrapper(impl)
}
