package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  MessageId,
  ChimeArn,
  Timestamp,
  NonNullableBoolean,
  Content,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class ChannelMessage(
    channelArn: Optional[ChimeArn] = Optional.Absent,
    messageId: Optional[MessageId] = Optional.Absent,
    content: Optional[Content] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    `type`: Optional[zio.aws.chime.model.ChannelMessageType] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastEditedTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    sender: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    redacted: Optional[NonNullableBoolean] = Optional.Absent,
    persistence: Optional[zio.aws.chime.model.ChannelMessagePersistenceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelMessage = {
    import ChannelMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelMessage
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastEditedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEditedTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(sender.map(value => value.buildAwsValue()))(_.sender)
      .optionallyWith(
        redacted.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.redacted)
      .optionallyWith(persistence.map(value => value.unwrap))(_.persistence)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelMessage.ReadOnly =
    zio.aws.chime.model.ChannelMessage.wrap(buildAwsValue())
}
object ChannelMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelMessage =
      zio.aws.chime.model.ChannelMessage(
        channelArn.map(value => value),
        messageId.map(value => value),
        content.map(value => value),
        metadata.map(value => value),
        `type`.map(value => value),
        createdTimestamp.map(value => value),
        lastEditedTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        sender.map(value => value.asEditable),
        redacted.map(value => value),
        persistence.map(value => value)
      )
    def channelArn: Optional[ChimeArn]
    def messageId: Optional[MessageId]
    def content: Optional[Content]
    def metadata: Optional[Metadata]
    def `type`: Optional[zio.aws.chime.model.ChannelMessageType]
    def createdTimestamp: Optional[Timestamp]
    def lastEditedTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def sender: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def redacted: Optional[NonNullableBoolean]
    def persistence: Optional[zio.aws.chime.model.ChannelMessagePersistenceType]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getType: ZIO[Any, AwsError, zio.aws.chime.model.ChannelMessageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastEditedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEditedTimestamp", lastEditedTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getSender: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("sender", sender)
    def getRedacted: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("redacted", redacted)
    def getPersistence: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ChannelMessagePersistenceType
    ] = AwsError.unwrapOptionField("persistence", persistence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelMessage
  ) extends zio.aws.chime.model.ChannelMessage.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chime.model.primitives.MessageId(value))
    override val content: Optional[Content] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.chime.model.primitives.Content(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val `type`: Optional[zio.aws.chime.model.ChannelMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.chime.model.ChannelMessageType.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val lastEditedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEditedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val sender: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sender())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val redacted: Optional[NonNullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.redacted())
      .map(value => zio.aws.chime.model.primitives.NonNullableBoolean(value))
    override val persistence
        : Optional[zio.aws.chime.model.ChannelMessagePersistenceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.persistence())
        .map(value =>
          zio.aws.chime.model.ChannelMessagePersistenceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelMessage
  ): zio.aws.chime.model.ChannelMessage.ReadOnly = new Wrapper(impl)
}
