package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ChannelMessagePersistenceType {
  def unwrap: software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType
}
object ChannelMessagePersistenceType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType
  ): zio.aws.chime.model.ChannelMessagePersistenceType = value match {
    case software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.PERSISTENT =>
      val r = PERSISTENT
      r
    case software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.NON_PERSISTENT =>
      val r = NON_PERSISTENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.ChannelMessagePersistenceType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType =
      software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERSISTENT
      extends zio.aws.chime.model.ChannelMessagePersistenceType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType =
      software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.PERSISTENT
  }
  case object NON_PERSISTENT
      extends zio.aws.chime.model.ChannelMessagePersistenceType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType =
      software.amazon.awssdk.services.chime.model.ChannelMessagePersistenceType.NON_PERSISTENT
  }
}
