package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  MessageId,
  Timestamp,
  NonNullableBoolean,
  Content,
  Metadata
}
import scala.jdk.CollectionConverters._
final case class ChannelMessageSummary(
    messageId: Optional[MessageId] = Optional.Absent,
    content: Optional[Content] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    `type`: Optional[zio.aws.chime.model.ChannelMessageType] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    lastEditedTimestamp: Optional[Timestamp] = Optional.Absent,
    sender: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    redacted: Optional[NonNullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelMessageSummary = {
    import ChannelMessageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelMessageSummary
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(
        lastEditedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastEditedTimestamp)
      .optionallyWith(sender.map(value => value.buildAwsValue()))(_.sender)
      .optionallyWith(
        redacted.map(value =>
          NonNullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.redacted)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelMessageSummary.ReadOnly =
    zio.aws.chime.model.ChannelMessageSummary.wrap(buildAwsValue())
}
object ChannelMessageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelMessageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelMessageSummary =
      zio.aws.chime.model.ChannelMessageSummary(
        messageId.map(value => value),
        content.map(value => value),
        metadata.map(value => value),
        `type`.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        lastEditedTimestamp.map(value => value),
        sender.map(value => value.asEditable),
        redacted.map(value => value)
      )
    def messageId: Optional[MessageId]
    def content: Optional[Content]
    def metadata: Optional[Metadata]
    def `type`: Optional[zio.aws.chime.model.ChannelMessageType]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def lastEditedTimestamp: Optional[Timestamp]
    def sender: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def redacted: Optional[NonNullableBoolean]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getType: ZIO[Any, AwsError, zio.aws.chime.model.ChannelMessageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getLastEditedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastEditedTimestamp", lastEditedTimestamp)
    def getSender: ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("sender", sender)
    def getRedacted: ZIO[Any, AwsError, NonNullableBoolean] =
      AwsError.unwrapOptionField("redacted", redacted)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelMessageSummary
  ) extends zio.aws.chime.model.ChannelMessageSummary.ReadOnly {
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.chime.model.primitives.MessageId(value))
    override val content: Optional[Content] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.chime.model.primitives.Content(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val `type`: Optional[zio.aws.chime.model.ChannelMessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.chime.model.ChannelMessageType.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val lastEditedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEditedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val sender: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sender())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val redacted: Optional[NonNullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.redacted())
      .map(value => zio.aws.chime.model.primitives.NonNullableBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelMessageSummary
  ): zio.aws.chime.model.ChannelMessageSummary.ReadOnly = new Wrapper(impl)
}
