package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ChannelMessageType {
  def unwrap: software.amazon.awssdk.services.chime.model.ChannelMessageType
}
object ChannelMessageType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ChannelMessageType
  ): zio.aws.chime.model.ChannelMessageType = value match {
    case software.amazon.awssdk.services.chime.model.ChannelMessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ChannelMessageType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.chime.model.ChannelMessageType.CONTROL =>
      val r = CONTROL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.ChannelMessageType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessageType =
      software.amazon.awssdk.services.chime.model.ChannelMessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.chime.model.ChannelMessageType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessageType =
      software.amazon.awssdk.services.chime.model.ChannelMessageType.STANDARD
  }
  case object CONTROL extends zio.aws.chime.model.ChannelMessageType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMessageType =
      software.amazon.awssdk.services.chime.model.ChannelMessageType.CONTROL
  }
}
