package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ChannelMode {
  def unwrap: software.amazon.awssdk.services.chime.model.ChannelMode
}
object ChannelMode {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ChannelMode
  ): zio.aws.chime.model.ChannelMode = value match {
    case software.amazon.awssdk.services.chime.model.ChannelMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ChannelMode.UNRESTRICTED =>
      val r = UNRESTRICTED
      r
    case software.amazon.awssdk.services.chime.model.ChannelMode.RESTRICTED =>
      val r = RESTRICTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.ChannelMode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMode =
      software.amazon.awssdk.services.chime.model.ChannelMode.UNKNOWN_TO_SDK_VERSION
  }
  case object UNRESTRICTED extends zio.aws.chime.model.ChannelMode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMode =
      software.amazon.awssdk.services.chime.model.ChannelMode.UNRESTRICTED
  }
  case object RESTRICTED extends zio.aws.chime.model.ChannelMode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelMode =
      software.amazon.awssdk.services.chime.model.ChannelMode.RESTRICTED
  }
}
