package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelModeratedByAppInstanceUserSummary(
    channelSummary: Optional[zio.aws.chime.model.ChannelSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary = {
    import ChannelModeratedByAppInstanceUserSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary
      .builder()
      .optionallyWith(channelSummary.map(value => value.buildAwsValue()))(
        _.channelSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly =
    zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary
      .wrap(buildAwsValue())
}
object ChannelModeratedByAppInstanceUserSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary =
      zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary(
        channelSummary.map(value => value.asEditable)
      )
    def channelSummary: Optional[zio.aws.chime.model.ChannelSummary.ReadOnly]
    def getChannelSummary
        : ZIO[Any, AwsError, zio.aws.chime.model.ChannelSummary.ReadOnly] =
      AwsError.unwrapOptionField("channelSummary", channelSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary
  ) extends zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly {
    override val channelSummary
        : Optional[zio.aws.chime.model.ChannelSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelSummary())
        .map(value => zio.aws.chime.model.ChannelSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelModeratedByAppInstanceUserSummary
  ): zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary.ReadOnly =
    new Wrapper(impl)
}
