package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{Timestamp, ChimeArn}
import scala.jdk.CollectionConverters._
final case class ChannelModerator(
    moderator: Optional[zio.aws.chime.model.Identity] = Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelModerator = {
    import ChannelModerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelModerator
      .builder()
      .optionallyWith(moderator.map(value => value.buildAwsValue()))(
        _.moderator
      )
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelModerator.ReadOnly =
    zio.aws.chime.model.ChannelModerator.wrap(buildAwsValue())
}
object ChannelModerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelModerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelModerator =
      zio.aws.chime.model.ChannelModerator(
        moderator.map(value => value.asEditable),
        channelArn.map(value => value),
        createdTimestamp.map(value => value),
        createdBy.map(value => value.asEditable)
      )
    def moderator: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def channelArn: Optional[ChimeArn]
    def createdTimestamp: Optional[Timestamp]
    def createdBy: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getModerator
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("moderator", moderator)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelModerator
  ) extends zio.aws.chime.model.ChannelModerator.ReadOnly {
    override val moderator: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderator())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.chime.model.primitives.Timestamp(value))
    override val createdBy: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelModerator
  ): zio.aws.chime.model.ChannelModerator.ReadOnly = new Wrapper(impl)
}
