package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChannelModeratorSummary(
    moderator: Optional[zio.aws.chime.model.Identity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelModeratorSummary = {
    import ChannelModeratorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelModeratorSummary
      .builder()
      .optionallyWith(moderator.map(value => value.buildAwsValue()))(
        _.moderator
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelModeratorSummary.ReadOnly =
    zio.aws.chime.model.ChannelModeratorSummary.wrap(buildAwsValue())
}
object ChannelModeratorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelModeratorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelModeratorSummary =
      zio.aws.chime.model
        .ChannelModeratorSummary(moderator.map(value => value.asEditable))
    def moderator: Optional[zio.aws.chime.model.Identity.ReadOnly]
    def getModerator
        : ZIO[Any, AwsError, zio.aws.chime.model.Identity.ReadOnly] =
      AwsError.unwrapOptionField("moderator", moderator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelModeratorSummary
  ) extends zio.aws.chime.model.ChannelModeratorSummary.ReadOnly {
    override val moderator: Optional[zio.aws.chime.model.Identity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moderator())
        .map(value => zio.aws.chime.model.Identity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelModeratorSummary
  ): zio.aws.chime.model.ChannelModeratorSummary.ReadOnly = new Wrapper(impl)
}
