package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ChannelPrivacy {
  def unwrap: software.amazon.awssdk.services.chime.model.ChannelPrivacy
}
object ChannelPrivacy {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ChannelPrivacy
  ): zio.aws.chime.model.ChannelPrivacy = value match {
    case software.amazon.awssdk.services.chime.model.ChannelPrivacy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ChannelPrivacy.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.chime.model.ChannelPrivacy.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.ChannelPrivacy {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelPrivacy =
      software.amazon.awssdk.services.chime.model.ChannelPrivacy.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.chime.model.ChannelPrivacy {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelPrivacy =
      software.amazon.awssdk.services.chime.model.ChannelPrivacy.PUBLIC
  }
  case object PRIVATE extends zio.aws.chime.model.ChannelPrivacy {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ChannelPrivacy =
      software.amazon.awssdk.services.chime.model.ChannelPrivacy.PRIVATE
  }
}
