package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.RetentionDays
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ChannelRetentionSettings(
    retentionDays: Optional[RetentionDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelRetentionSettings = {
    import ChannelRetentionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelRetentionSettings
      .builder()
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelRetentionSettings.ReadOnly =
    zio.aws.chime.model.ChannelRetentionSettings.wrap(buildAwsValue())
}
object ChannelRetentionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelRetentionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelRetentionSettings =
      zio.aws.chime.model
        .ChannelRetentionSettings(retentionDays.map(value => value))
    def retentionDays: Optional[RetentionDays]
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelRetentionSettings
  ) extends zio.aws.chime.model.ChannelRetentionSettings.ReadOnly {
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.chime.model.primitives.RetentionDays(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelRetentionSettings
  ): zio.aws.chime.model.ChannelRetentionSettings.ReadOnly = new Wrapper(impl)
}
