package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Timestamp,
  Metadata,
  ChimeArn,
  NonEmptyResourceName
}
import scala.jdk.CollectionConverters._
final case class ChannelSummary(
    name: Optional[NonEmptyResourceName] = Optional.Absent,
    channelArn: Optional[ChimeArn] = Optional.Absent,
    mode: Optional[zio.aws.chime.model.ChannelMode] = Optional.Absent,
    privacy: Optional[zio.aws.chime.model.ChannelPrivacy] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    lastMessageTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChannelSummary = {
    import ChannelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChannelSummary
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(privacy.map(value => value.unwrap))(_.privacy)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        lastMessageTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChannelSummary.ReadOnly =
    zio.aws.chime.model.ChannelSummary.wrap(buildAwsValue())
}
object ChannelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChannelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChannelSummary =
      zio.aws.chime.model.ChannelSummary(
        name.map(value => value),
        channelArn.map(value => value),
        mode.map(value => value),
        privacy.map(value => value),
        metadata.map(value => value),
        lastMessageTimestamp.map(value => value)
      )
    def name: Optional[NonEmptyResourceName]
    def channelArn: Optional[ChimeArn]
    def mode: Optional[zio.aws.chime.model.ChannelMode]
    def privacy: Optional[zio.aws.chime.model.ChannelPrivacy]
    def metadata: Optional[Metadata]
    def lastMessageTimestamp: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getMode: ZIO[Any, AwsError, zio.aws.chime.model.ChannelMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getPrivacy: ZIO[Any, AwsError, zio.aws.chime.model.ChannelPrivacy] =
      AwsError.unwrapOptionField("privacy", privacy)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getLastMessageTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastMessageTimestamp", lastMessageTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChannelSummary
  ) extends zio.aws.chime.model.ChannelSummary.ReadOnly {
    override val name: Optional[NonEmptyResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.NonEmptyResourceName(value))
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
    override val mode: Optional[zio.aws.chime.model.ChannelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.chime.model.ChannelMode.wrap(value))
    override val privacy: Optional[zio.aws.chime.model.ChannelPrivacy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privacy())
        .map(value => zio.aws.chime.model.ChannelPrivacy.wrap(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val lastMessageTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageTimestamp())
        .map(value => zio.aws.chime.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChannelSummary
  ): zio.aws.chime.model.ChannelSummary.ReadOnly = new Wrapper(impl)
}
