package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChimeSdkMeetingConfiguration(
    sourceConfiguration: Optional[zio.aws.chime.model.SourceConfiguration] =
      Optional.Absent,
    artifactsConfiguration: Optional[
      zio.aws.chime.model.ArtifactsConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration = {
    import ChimeSdkMeetingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration
      .builder()
      .optionallyWith(sourceConfiguration.map(value => value.buildAwsValue()))(
        _.sourceConfiguration
      )
      .optionallyWith(
        artifactsConfiguration.map(value => value.buildAwsValue())
      )(_.artifactsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly =
    zio.aws.chime.model.ChimeSdkMeetingConfiguration.wrap(buildAwsValue())
}
object ChimeSdkMeetingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ChimeSdkMeetingConfiguration =
      zio.aws.chime.model.ChimeSdkMeetingConfiguration(
        sourceConfiguration.map(value => value.asEditable),
        artifactsConfiguration.map(value => value.asEditable)
      )
    def sourceConfiguration
        : Optional[zio.aws.chime.model.SourceConfiguration.ReadOnly]
    def artifactsConfiguration
        : Optional[zio.aws.chime.model.ArtifactsConfiguration.ReadOnly]
    def getSourceConfiguration
        : ZIO[Any, AwsError, zio.aws.chime.model.SourceConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("sourceConfiguration", sourceConfiguration)
    def getArtifactsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.ArtifactsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "artifactsConfiguration",
      artifactsConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration
  ) extends zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly {
    override val sourceConfiguration
        : Optional[zio.aws.chime.model.SourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConfiguration())
        .map(value => zio.aws.chime.model.SourceConfiguration.wrap(value))
    override val artifactsConfiguration
        : Optional[zio.aws.chime.model.ArtifactsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactsConfiguration())
        .map(value => zio.aws.chime.model.ArtifactsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ChimeSdkMeetingConfiguration
  ): zio.aws.chime.model.ChimeSdkMeetingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
