package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContentArtifactsConfiguration(
    state: zio.aws.chime.model.ArtifactsState,
    muxType: Optional[zio.aws.chime.model.ContentMuxType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ContentArtifactsConfiguration = {
    import ContentArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ContentArtifactsConfiguration
      .builder()
      .state(state.unwrap)
      .optionallyWith(muxType.map(value => value.unwrap))(_.muxType)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly =
    zio.aws.chime.model.ContentArtifactsConfiguration.wrap(buildAwsValue())
}
object ContentArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ContentArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ContentArtifactsConfiguration =
      zio.aws.chime.model
        .ContentArtifactsConfiguration(state, muxType.map(value => value))
    def state: zio.aws.chime.model.ArtifactsState
    def muxType: Optional[zio.aws.chime.model.ContentMuxType]
    def getState: ZIO[Any, Nothing, zio.aws.chime.model.ArtifactsState] =
      ZIO.succeed(state)
    def getMuxType: ZIO[Any, AwsError, zio.aws.chime.model.ContentMuxType] =
      AwsError.unwrapOptionField("muxType", muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ContentArtifactsConfiguration
  ) extends zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly {
    override val state: zio.aws.chime.model.ArtifactsState =
      zio.aws.chime.model.ArtifactsState.wrap(impl.state())
    override val muxType: Optional[zio.aws.chime.model.ContentMuxType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.muxType())
        .map(value => zio.aws.chime.model.ContentMuxType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ContentArtifactsConfiguration
  ): zio.aws.chime.model.ContentArtifactsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
