package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait ContentMuxType {
  def unwrap: software.amazon.awssdk.services.chime.model.ContentMuxType
}
object ContentMuxType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.ContentMuxType
  ): zio.aws.chime.model.ContentMuxType = value match {
    case software.amazon.awssdk.services.chime.model.ContentMuxType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.ContentMuxType.CONTENT_ONLY =>
      val r = ContentOnly
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.ContentMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ContentMuxType =
      software.amazon.awssdk.services.chime.model.ContentMuxType.UNKNOWN_TO_SDK_VERSION
  }
  case object ContentOnly extends zio.aws.chime.model.ContentMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.ContentMuxType =
      software.amazon.awssdk.services.chime.model.ContentMuxType.CONTENT_ONLY
  }
}
