package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.RetentionDays
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ConversationRetentionSettings(
    retentionDays: Optional[RetentionDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.ConversationRetentionSettings = {
    import ConversationRetentionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.ConversationRetentionSettings
      .builder()
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.ConversationRetentionSettings.ReadOnly =
    zio.aws.chime.model.ConversationRetentionSettings.wrap(buildAwsValue())
}
object ConversationRetentionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.ConversationRetentionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.ConversationRetentionSettings =
      zio.aws.chime.model
        .ConversationRetentionSettings(retentionDays.map(value => value))
    def retentionDays: Optional[RetentionDays]
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.ConversationRetentionSettings
  ) extends zio.aws.chime.model.ConversationRetentionSettings.ReadOnly {
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.chime.model.primitives.RetentionDays(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.ConversationRetentionSettings
  ): zio.aws.chime.model.ConversationRetentionSettings.ReadOnly = new Wrapper(
    impl
  )
}
