package zio.aws.chime.model
import zio.aws.chime.model.primitives.AccountName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAccountRequest(name: AccountName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAccountRequest = {
    import CreateAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAccountRequest
      .builder()
      .name(AccountName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAccountRequest.ReadOnly =
    zio.aws.chime.model.CreateAccountRequest.wrap(buildAwsValue())
}
object CreateAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAccountRequest =
      zio.aws.chime.model.CreateAccountRequest(name)
    def name: AccountName
    def getName: ZIO[Any, Nothing, AccountName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAccountRequest
  ) extends zio.aws.chime.model.CreateAccountRequest.ReadOnly {
    override val name: AccountName =
      zio.aws.chime.model.primitives.AccountName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAccountRequest
  ): zio.aws.chime.model.CreateAccountRequest.ReadOnly = new Wrapper(impl)
}
