package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccountResponse(
    account: Optional[zio.aws.chime.model.Account] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.CreateAccountResponse = {
    import CreateAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.CreateAccountResponse
      .builder()
      .optionallyWith(account.map(value => value.buildAwsValue()))(_.account)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.CreateAccountResponse.ReadOnly =
    zio.aws.chime.model.CreateAccountResponse.wrap(buildAwsValue())
}
object CreateAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.CreateAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.CreateAccountResponse =
      zio.aws.chime.model
        .CreateAccountResponse(account.map(value => value.asEditable))
    def account: Optional[zio.aws.chime.model.Account.ReadOnly]
    def getAccount: ZIO[Any, AwsError, zio.aws.chime.model.Account.ReadOnly] =
      AwsError.unwrapOptionField("account", account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.CreateAccountResponse
  ) extends zio.aws.chime.model.CreateAccountResponse.ReadOnly {
    override val account: Optional[zio.aws.chime.model.Account.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.account())
        .map(value => zio.aws.chime.model.Account.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.CreateAccountResponse
  ): zio.aws.chime.model.CreateAccountResponse.ReadOnly = new Wrapper(impl)
}
